<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name="mnlno"></xsl:param>
<xsl:param name="orderType">normal</xsl:param>
<xsl:param name="polink"></xsl:param>
<xsl:param name="lang">en</xsl:param>
<xsl:template match="/">
<!-- Build = 2006.03.17 -->
<html>
<body>
	<a name='top'></a>
	<form name='form1' action='' method='post' enctype='text/plain'>
		<table width="600">
			<tr>
				<td>
					<table border="1" width="100%">
						<tr>
							<th align="left" nowrap="nowrap"><xsl:if test="$lang != 'ja'">Model No.</xsl:if><xsl:if test="$lang = 'ja'">モデルNo.</xsl:if></th>
							<td width="90%"><span id='mdlno'></span></td>
						</tr>
						<tr>
							<th align="left" nowrap="nowrap"><xsl:if test="$lang != 'ja'">Manual No.</xsl:if><xsl:if test="$lang = 'ja'">マニュアルNo.</xsl:if></th>
							<td><xsl:value-of select='$mnlno'/></td>
						</tr>
						<xsl:choose>
							<xsl:when test="$orderType = 'jpost'">
								<tr>
									<th align="left" nowrap="nowrap">P/O No.</th>
									<td>
										<input type='text' id='po' maxlength='15' size='20' onblur="buff_jpost('PO',this);" style="text-transform:uppercase"/>
									</td>
								</tr>
								<tr>
									<th align="left" nowrap="nowrap">Shipping Method</th>
									<td>
										<select id='sm' size='1' onChange="buff_jpost('SM',this)">
										    <option value=''>--- Select Method ---</option>
										    <option value='AIR'>AIR</option>
										    <option value='SEA'>SEA</option>
										    <option value='COURIER'>COURIER</option>
										    <option value='MAIL'>MAIL</option>
										    <option value='SEA%26AIR'>SEA&amp;AIR</option>
										    <option value='TRUCK'>TRUCK</option>
									    </select>
									</td>
								</tr>
								<tr>
									<th align="left" nowrap="nowrap">Memo</th>
									<td>
										<input type='text' id='me' maxlength='25' size='40' onblur="buff_jpost('ME',this)"/>
									</td>
								</tr>
								<tr>
									<th align="left" nowrap="nowrap">Urgent</th>
									<td>
										<select id='ur' size='1' onChange="buff_jpost('UR',this)">
										    <option value=''>No</option>
										    <option value='1'>Yes</option>
										</select>
									</td>
								</tr>
							</xsl:when>
							<xsl:when test="$orderType = 'jasper'">
								<tr>
									<th align="left" nowrap="nowrap">P/O No.</th>
									<td>
										<input type='text' id='po' maxlength='15' size='20' onblur="buff_jasper('PO',this)" style="text-transform:uppercase"/>
									</td>
								</tr>
							</xsl:when>
							<xsl:when test="$orderType = 'web'">
								<tr>
									<th align="left" nowrap="nowrap">P/O No.</th>
									<td>
										<input type='text' id='po' maxlength='15' size='20' onblur="buff_web('PO',this)" style="text-transform:uppercase"/>
									</td>
								</tr>
							</xsl:when>
						</xsl:choose>
					</table>
					<br/>
				</td>
			</tr>
			<tr>
				<td>
					<xsl:call-template name="mainTable"/>
				</td>
			</tr>
		</table>
	</form>
</body>
</html>
</xsl:template>

<xsl:template name="mainTable">
	<table border="1" width="100%" id="tbl">
		<tr>
			<th>NO.</th>
			<th><xsl:if test="$lang != 'ja'">BLOCK</xsl:if><xsl:if test="$lang = 'ja'">ブロック</xsl:if></th>
			<th><xsl:if test="$lang != 'ja'">REF NO.</xsl:if><xsl:if test="$lang = 'ja'">シンボルNo.</xsl:if></th>
			<th><xsl:if test="$lang != 'ja'">PART NO.</xsl:if><xsl:if test="$lang = 'ja'">部品番号</xsl:if></th>
			<th><xsl:if test="$lang != 'ja'">PART NAME</xsl:if><xsl:if test="$lang = 'ja'">部品名</xsl:if></th>
			<th><xsl:if test="$lang != 'ja'">QTY</xsl:if><xsl:if test="$lang = 'ja'">個数</xsl:if></th>
			<th><xsl:if test="$lang != 'ja'">REMARKS</xsl:if><xsl:if test="$lang = 'ja'">備考</xsl:if></th>
			<th><xsl:if test="$lang != 'ja'">ACTION</xsl:if><xsl:if test="$lang = 'ja'">操作</xsl:if></th>
		</tr>
		<xsl:apply-templates select="//ROW">
		</xsl:apply-templates>
	</table>
	<a name='bottom'></a>
	<table width='100%'>
		<tr>
			<td align='right'>
				<a href="#top"><xsl:if test="$lang != 'ja'">to TOP</xsl:if><xsl:if test="$lang = 'ja'">↑最初へ</xsl:if></a>
			</td>
		</tr>
	</table>
	<table align="center">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="$orderType = 'normal'">
						<input type='button' id='mailbtn' value='Mailto' onclick='textout("normal");'>
							<xsl:if test="count(//ROW/PART[. != '']) = 0">
								<xsl:attribute name="disabled">
									disabled
								</xsl:attribute>
							</xsl:if>
						</input>
					</xsl:when>
					<xsl:when test="$orderType = 'jpost'">
						<input type='button' id='poBtn' value='Output Text(CSV)' onclick='textout("csv");'>
							<xsl:if test="count(//ROW/PART[. != '']) = 0">
								<xsl:attribute name="disabled">
									disabled
								</xsl:attribute>
							</xsl:if>
						</input>
						<input type='button' id='mailbtn' value='Order (Mailto)' onclick='textout("jpost");'>
							<xsl:if test="count(//ROW/PART[. != '']) = 0">
								<xsl:attribute name="disabled">
									disabled
								</xsl:attribute>
							</xsl:if>
						</input>
					</xsl:when>
					<xsl:when test="$orderType = 'jasper'">
						<input type='button' id='mailbtn1' value='Order (Mailto)' onclick='textout("jasper1");'>
							<xsl:if test="count(//ROW/PART[. != '']) = 0">
								<xsl:attribute name="disabled">
									disabled
								</xsl:attribute>
							</xsl:if>
						</input>
						<input type='button' id='mailbtn2' value='Inquiry (Mailto)' onclick='textout("jasper2");'>
							<xsl:if test="count(//ROW/PART[. != '']) = 0">
								<xsl:attribute name="disabled">
									disabled
								</xsl:attribute>
							</xsl:if>
						</input>
						<!--<input type='button' id='mailbtn3' value='Backorder (Mailto)' onclick='textout("jasper3");'>
							<xsl:if test="count(//ROW/PART[. != '']) = 0">
								<xsl:attribute name="disabled">
									disabled
								</xsl:attribute>
							</xsl:if>
						</input>-->
					</xsl:when>
					<xsl:when test="$orderType = 'web'">
						<input type='button' id='poBtn' onclick='textout("web");'>
							<xsl:attribute name="value">
								<xsl:value-of select='$polink'/>
							</xsl:attribute>
							<xsl:if test="count(//ROW/PART[. != '']) = 0">
								<xsl:attribute name="disabled">
									disabled
								</xsl:attribute>
							</xsl:if>
						</input>
					</xsl:when>
				</xsl:choose>
			</td>
			<td>
				<input type='button' onClick='window.print();'>
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Print Screen</xsl:if><xsl:if test="$lang = 'ja'">画面印刷</xsl:if>
					</xsl:attribute>
				</input>
			</td>
			<td>
				<input type='button' id='btn' onClick='clearItem();'>
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Clear</xsl:if><xsl:if test="$lang = 'ja'">クリア</xsl:if>
					</xsl:attribute>
				</input>
			</td>
			<td>
				<input type='button' id='btn' onClick='window.close();'>
					<xsl:attribute name="value">
						<xsl:if test="$lang != 'ja'">Close</xsl:if><xsl:if test="$lang = 'ja'">閉じる</xsl:if>
					</xsl:attribute>
				</input>
			</td>
		</tr>
	</table>
</xsl:template>

<xsl:template match="/PARTSORDER/ROW">
	<tr>
		<td align="center" nowrap="nowrap">
			<xsl:value-of select="position()"/>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="BLKNO[. != '']"><xsl:value-of select="BLKNO"/></xsl:if>
			<xsl:if test="BLKNO[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="SYMBOL[. != '']"><xsl:value-of select="SYMBOL"/></xsl:if>
			<xsl:if test="SYMBOL[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="PART[. != '']"><xsl:value-of select="PART"/></xsl:if>
			<xsl:if test="PART[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="NAME[. != '']"><xsl:value-of select="NAME"/></xsl:if>
			<xsl:if test="NAME[. = '']"><br/></xsl:if>
		</td>
		<td nowrap="nowrap">
			<input type="text" id="qty" size="2" maxlength="2" onkeypress="toNum(event.keyCode)">
				<xsl:attribute name="value">
					<xsl:value-of select="ORDERQTY"/>
				</xsl:attribute>
				<xsl:attribute name="onblur">
					setValue('<xsl:value-of select="@ID"/>',this)
				</xsl:attribute>
			</input>
		</td>
		<td nowrap="nowrap">
			<input type="text" id="remarks" size="5" maxlength="15" style="text-transform:uppercase">
				<xsl:attribute name="value">
					<xsl:value-of select="REMARKS"/>
				</xsl:attribute>
				<xsl:attribute name="onblur">
					setRemarks('<xsl:value-of select="@ID"/>',this)
				</xsl:attribute>
			</input>
		</td>
		<td nowrap="nowrap">
			<input type="button" id="rmvBtn">
				<xsl:attribute name="value">
					<xsl:if test="$lang != 'ja'">Delete</xsl:if><xsl:if test="$lang = 'ja'">削除</xsl:if>
				</xsl:attribute>
				<xsl:attribute name="onClick">
					deleteItem('<xsl:value-of select="@ID"/>')
				</xsl:attribute>
			</input>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
